/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class FileConnectSampleCanvas
extends Canvas
implements CommandListener,
Runnable {
    String info;
    Command getCmd = new Command("GET", 1, 0);
    Command exitCmd = new Command("Exit", 7, 1);
    Command okCmd;
    TextBox textBox;

    public FileConnectSampleCanvas() {
        this.addCommand(this.getCmd);
        this.addCommand(this.exitCmd);
        this.setCommandListener(this);
        this.textBox = new TextBox("input file", "file://localhost/", 256, 0);
        this.okCmd = new Command("OK", 1, 0);
        this.textBox.addCommand(this.okCmd);
        this.textBox.addCommand(this.exitCmd);
        this.textBox.setCommandListener((CommandListener)this);
        this.info = null;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(0, 0, 0);
        graphics.drawString("FileConnectSample test. press [GET]key.", 0, 0, 20);
        if (this.info != null) {
            graphics.drawString("" + this.info, 0, 40, 20);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.getCmd) {
            Display.getDisplay((MIDlet)FileConnectSample.midlet).setCurrent((Displayable)this.textBox);
        } else if (command == this.okCmd) {
            Display.getDisplay((MIDlet)FileConnectSample.midlet).setCurrent((Displayable)this);
            Thread thread = new Thread(this);
            thread.start();
        } else if (command == this.exitCmd) {
            FileConnectSample.midlet.notifyDestroyed();
        }
    }

    public void run() {
        this.showFile(this.textBox.getString());
        this.repaint();
    }

    void showFile(String string) {
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)string);
            InputStream inputStream = fileConnection.openInputStream();
            byte[] byArray = new byte[1024];
            int n = inputStream.read(byArray, 0, 1024);
            inputStream.close();
            fileConnection.close();
            this.info = n > 0 ? new String(byArray, 0, n) : "read error";
        }
        catch (Exception exception) {
            this.info = "Exception error";
        }
    }
}

