/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class HttpSampleCanvas
extends Canvas
implements CommandListener,
Runnable {
    String url;
    String info;
    Command soft1;
    Command exit;
    Command okCmd;
    TextBox textBox;
    Font font = Font.getFont((int)32, (int)0, (int)8);

    public HttpSampleCanvas() {
        this.soft1 = new Command("GET", 1, 0);
        this.exit = new Command("Exit", 7, 1);
        this.addCommand(this.soft1);
        this.addCommand(this.exit);
        this.setCommandListener(this);
        this.textBox = new TextBox("input URL", "http://", 256, 0);
        this.okCmd = new Command("OK", 1, 0);
        this.textBox.addCommand(this.okCmd);
        this.textBox.addCommand(this.exit);
        this.textBox.setCommandListener((CommandListener)this);
        this.info = null;
        this.url = null;
    }

    public void paint(Graphics graphics) {
        graphics.setFont(this.font);
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(0, 0, 0);
        graphics.drawString("HttpSample test. press [GET]key.", 0, 0, 20);
        if (this.info != null) {
            graphics.drawString("" + this.info, 0, 40, 20);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.soft1) {
            Display.getDisplay((MIDlet)HttpSample.midlet).setCurrent((Displayable)this.textBox);
        } else if (command == this.okCmd) {
            this.url = this.textBox.getString();
            Display.getDisplay((MIDlet)HttpSample.midlet).setCurrent((Displayable)this);
            Thread thread = new Thread(this);
            thread.start();
        } else if (command == this.exit) {
            HttpSample.midlet.notifyDestroyed();
        }
    }

    public void run() {
        this.info = this.readText(this.url);
        if (this.info == null) {
            this.info = "read error";
        }
        this.repaint();
    }

    private String readText(String string) {
        HttpConnection httpConnection = null;
        InputStream inputStream = null;
        try {
            httpConnection = (HttpConnection)Connector.open((String)string);
            inputStream = httpConnection.openInputStream();
            int n = (int)httpConnection.getLength();
            if (n < 0) {
                n = 256;
            }
            byte[] byArray = new byte[n];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)inputStream.read();
            }
            inputStream.close();
            httpConnection.close();
            return new String(byArray);
        }
        catch (Exception exception) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (httpConnection != null) {
                    httpConnection.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
    }
}

