/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class RSSampleCanvas
extends Canvas
implements CommandListener {
    byte[] data = new byte[3];
    Command softKey1;
    Command softKey2;
    Command exit;
    int index = 0;
    int keyState;

    RSSampleCanvas() {
        this.data[0] = 0;
        this.data[1] = 0;
        this.data[2] = 0;
        this.setCommandListener(this);
        this.softKey1 = new Command("Load", 1, 0);
        this.softKey2 = new Command("Save", 1, 1);
        this.exit = new Command("EXIT", 7, 3);
        this.addCommand(this.softKey1);
        this.addCommand(this.softKey2);
        this.addCommand(this.exit);
        this.index = 0;
        this.keyState = 0;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exit) {
            RSSample.midlet.notifyDestroyed();
        }
        if (command == this.softKey1) {
            this.RSLoad();
        }
        if (command == this.softKey2) {
            this.RSSave();
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (50 == this.keyState) {
            this.index = this.index - 1 < 0 ? 2 : this.index - 1;
        } else if (56 == this.keyState) {
            this.index = this.index + 1 > 2 ? 0 : this.index + 1;
        } else if (53 == this.keyState) {
            if (this.data[this.index] + 1 == 255) {
                this.data[this.index] = 0;
            } else {
                int n = this.index;
                this.data[n] = (byte)(this.data[n] + 1);
            }
        }
        graphics.setColor(250, 255, 255);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int i = 1; i < 4; ++i) {
            if (i == this.index + 1) {
                graphics.setColor(255, 0, 0);
            } else {
                graphics.setColor(0, 0, 0);
            }
            graphics.drawString("state" + i + ":" + this.data[i - 1], 10, 10 + 40 * (i - 1), 20);
        }
    }

    public void keyPressed(int n) {
        block0 : switch (n) {
            case 50: {
                this.keyState = 50;
                break;
            }
            case 56: {
                this.keyState = 56;
                break;
            }
            case 53: {
                this.keyState = 53;
                break;
            }
            default: {
                switch (this.getGameAction(n)) {
                    case 1: {
                        this.keyState = 50;
                        break block0;
                    }
                    case 6: {
                        this.keyState = 56;
                        break block0;
                    }
                    case 8: {
                        this.keyState = 53;
                    }
                }
            }
        }
        this.repaint();
    }

    public void keyReleased(int n) {
        this.keyState = 0;
        this.repaint();
    }

    void RSLoad() {
        RecordStore recordStore = null;
        int n = 0;
        try {
            recordStore = RecordStore.openRecordStore((String)"RSSample_saveinfo", (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.closeRecordStore();
                this.data[0] = 0;
                this.data[1] = 0;
                this.data[2] = 0;
                System.gc();
                return;
            }
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, true);
            while (recordEnumeration.hasNextElement()) {
                n = recordEnumeration.nextRecordId();
            }
            recordStore.getRecord(n, this.data, 0);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    void RSSave() {
        RecordStore recordStore = null;
        int n = 0;
        try {
            recordStore = RecordStore.openRecordStore((String)"RSSample_saveinfo", (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(this.data, 0, this.data.length);
                recordStore.closeRecordStore();
                System.gc();
                return;
            }
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, true);
            while (recordEnumeration.hasNextElement()) {
                n = recordEnumeration.nextRecordId();
            }
            recordStore.setRecord(n, this.data, 0, this.data.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }
}

