import java.util.*;
import java.io.*;
import javax.microedition.io.*;
import javax.microedition.io.file.*;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

/**[̃f[^ɃANZX邽߂̃Tv */
public class FileConnectSampleCanvas extends Canvas
	implements CommandListener,Runnable
{
	String info;
	Command getCmd;
	Command exitCmd;
	Command okCmd;
	TextBox textBox;

	//RXgN^
    public FileConnectSampleCanvas(){
		//softkeyݒ
		getCmd = new Command("GET",Command.SCREEN,0);
		exitCmd   = new Command("Exit",Command.EXIT, 1);
		addCommand(getCmd);
		addCommand(exitCmd);
		setCommandListener(this);

		//eLXg{bNX̐ݒ
		textBox = new TextBox("input file","file://localhost/",256,0);
		okCmd = new Command("OK",Command.SCREEN,0);
		textBox.addCommand(okCmd);
		textBox.addCommand(exitCmd);
		textBox.setCommandListener(this);

		//info
		info=null;
    }


	// ` 
	public void paint(Graphics g) 
	{
		g.setColor(255,255,255);
		g.fillRect(0,0,getWidth(),getHeight());
		g.setColor(0,0,0);
		g.drawString("FileConnectSample test. press [GET]key.",0,0,Graphics.LEFT|Graphics.TOP);

		if(info !=null)
		{
			g.drawString(""+info,0,40,Graphics.LEFT|Graphics.TOP);
		}

	}
  

    public void commandAction(Command c, Displayable d) {
		if(c==getCmd)
		{
			//GET{^ꂽƂɂ́A
			//eLXg{bNXʂɂē͂
			Display.getDisplay( FileConnectSample.midlet).setCurrent(textBox);
		}
		else if(c==okCmd)
		{
			//eLXg{bNXʂOK
			// ͂ꂽ擾Ảʂɖ߂
			Display.getDisplay( FileConnectSample.midlet).setCurrent(this);
			
			//R}hANVł͕ʃXbhōsKv̂
			//showFile͕ʃXbhōsB
			Thread th = new Thread(this);
			th.start();
		}
		else if(c==exitCmd)
		{
			 FileConnectSample.midlet.notifyDestroyed();
		}
    }   

	public void run() {
		showFile(textBox.getString());
		repaint();
	}
     
    void showFile(String fileName) {
        try {
            FileConnection fc = (FileConnection)Connector.open(fileName);
            
            InputStream fis = fc.openInputStream();
            byte[] b = new byte[1024];
            
            int length = fis.read(b, 0, 1024);
            
            fis.close();
            fc.close();

			if (length > 0) 
			{
				info = new String(b, 0, length);
			}else{
				info = "read error";
			}

        } catch (Exception e) {
			info="Exception error";
		}
        
    }
}
