import javax.microedition.lcdui.*;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.game.*;
import javax.microedition.rms.*;

/** R[hXgA Tv */
public class RSSampleCanvas extends Canvas 
	implements CommandListener
{

	byte data[] =new byte[3];//SaveELoadp̃f[^
	Command  softKey1; //\tgL[
	Command  softKey2; //\tgL[
	Command  exit;
	int index=0;
	int keyState; //L[Xe[g

	
	//RXgN^
	RSSampleCanvas()
	{
		//datȁ
		data[2]=data[1]=data[0]=0;

		//\tgL[̒ǉ
		setCommandListener(this);
		softKey1=new Command("Load",Command.SCREEN,0);
		softKey2=new Command("Save",Command.SCREEN,1);
		exit    =new Command("EXIT",Command.EXIT,3);
		addCommand(softKey1);
		addCommand(softKey2);
		addCommand(exit);

		index=0;
		keyState=0;
	}

	//\tgL[Cxg
	public void commandAction(Command c,Displayable s) 
	{
		if( c==exit){
			//Av̏Iʒm
			RSSample.midlet.notifyDestroyed();
		}
		if (c==softKey1){RSLoad();}
		if (c==softKey2){RSSave();}
		repaint();
	}

	public void paint(Graphics g)
	{

		if (KEY_NUM2   == keyState)
		{
			index = (index-1)<0 ? 2 : (index-1);
		}else if (KEY_NUM8 ==keyState){
			index = (index+1)>2 ? 0 : (index+1);
		}else if (KEY_NUM5 ==keyState){
			if( (data[index]+1)==255)
			{
				data[index]=0;
			}
			else
			{
				data[index]++;
			}
		}

		//ʃIuWFNg̃NA
		g.setColor(250,255,255);
		g.fillRect(0,0,getWidth(),getHeight());
			
		for(int i=1;i<4;i++)
		{
			if( i == (index+1) )
			{
				g.setColor(255,0,0);
			}
			else
			{
				g.setColor(0,0,0);
			}
			g.drawString("state"+i+":"+data[i-1],10,10+40*(i-1),
				Graphics.TOP|Graphics.LEFT);
		}
	}

	//L[vXCxg
	public void keyPressed(int keyCode) 
	{
		switch(keyCode) 
		{
			//L[ELL[
			case KEY_NUM2: keyState = KEY_NUM2;break;
			case KEY_NUM8: keyState = KEY_NUM8;break;
			case KEY_NUM5: keyState = KEY_NUM5;break;
			//L[EL[
			default:
			switch(getGameAction(keyCode)) 
			{
				case UP:   keyState = KEY_NUM2;break;
				case DOWN: keyState = KEY_NUM8;break;
				case FIRE: keyState = KEY_NUM5;break;
			}
		}
		repaint();
	}

	//L[[XCxg
	public void keyReleased(int keyCode) 
	{
		keyState=0;
		repaint();
	}

	void RSLoad()
	{
		// R[hXgAt@C̃f[^̓ǂݍݏ
		// 1:RecordStore recordStoreName J
		//   ̏ꍇARSSample_saveinfo
		// 2:getNumRecordsŃR[h擾
		//@ 0̏ꍇ́AR[hȂ̂ŕۑf[^ȂƂɂȂ
		// 3:R[hID擾Af[^ǂݍ
		RecordStore rs = null;
		int id = 0;
		try
		{
			rs = RecordStore.openRecordStore("RSSample_saveinfo",true);
			if(rs.getNumRecords() == 0)
			{
				rs.closeRecordStore();

				data[2]=data[1]=data[0]=0;
			
				System.gc();
				return;
			}
			RecordEnumeration re = rs.enumerateRecords(null, null, true);
			while(re.hasNextElement())
			{
				id = re.nextRecordId();
			}
			rs.getRecord(id,data,0);
			rs.closeRecordStore();
		}
		catch(Exception e){}
		System.gc();
	}

	void RSSave()
	{
		// R[hXgAt@CɃf[^
		// 1:RecordStore recordStoreName J
		//   ̏ꍇARSSample_saveinfo
		// 2:getNumRecordsŃR[h擾
		//@ 0̏ꍇ́AR[hȂ̂ŕۑf[^ȂƂɂȂ
		//   addRecordŗ̈mۂ
		// 3:R[hID擾Af[^
		RecordStore rs = null;
		int id = 0;
		try
		{
			rs = RecordStore.openRecordStore("RSSample_saveinfo",true);
			
			if(rs.getNumRecords() == 0)
			{
				rs.addRecord(data, 0, data.length);
				rs.closeRecordStore();
				
				System.gc();
				return;
			}
			RecordEnumeration re = rs.enumerateRecords(null, null, true);
			while(re.hasNextElement())
			{
				id = re.nextRecordId();
			}
			rs.setRecord(id,data,0,data.length);
			rs.closeRecordStore();
		}
		catch(Exception e){}
		System.gc();
	}
}
	